
import gurobipy as gp

# Create a new model
model = gp.Model("Vitamin_Optimization")

# Define the variables
milligrams_vitamin_E = model.addVar(name="milligrams_vitamin_E", integer=True)
milligrams_vitamin_B9 = model.addVar(name="milligrams_vitamin_B9")

# Objective function: Minimize 4.45 * milligrams_vitamin_E + 1.29 * milligrams_vitamin_B9
model.setObjective(4.45 * milligrams_vitamin_E + 1.29 * milligrams_vitamin_B9, gp.GRB.MINIMIZE)

# Constraints
# Cognitive performance index constraint: 1 * milligrams_vitamin_E + 7 * milligrams_vitamin_B9 >= 21
model.addConstr(1 * milligrams_vitamin_E + 7 * milligrams_vitamin_B9 >= 21, name="cognitive_performance_index_min")

# Cognitive performance index constraint: 1 * milligrams_vitamin_E + 7 * milligrams_vitamin_B9 <= 47
model.addConstr(1 * milligrams_vitamin_E + 7 * milligrams_vitamin_B9 <= 47, name="cognitive_performance_index_max")

# Muscle growth index constraint: 2 * milligrams_vitamin_E + 2 * milligrams_vitamin_B9 >= 20
model.addConstr(2 * milligrams_vitamin_E + 2 * milligrams_vitamin_B9 >= 20, name="muscle_growth_index_min")

# Muscle growth index constraint: 2 * milligrams_vitamin_E + 2 * milligrams_vitamin_B9 <= 28
model.addConstr(2 * milligrams_vitamin_E + 2 * milligrams_vitamin_B9 <= 28, name="muscle_growth_index_max")

# Linear constraint: -3 * milligrams_vitamin_E + 6 * milligrams_vitamin_B9 >= 0
model.addConstr(-3 * milligrams_vitamin_E + 6 * milligrams_vitamin_B9 >= 0, name="linear_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Milligrams of Vitamin E: {milligrams_vitamin_E.varValue}")
    print(f"Milligrams of Vitamin B9: {milligrams_vitamin_B9.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
