
from gurobipy import Model, GRB, quicksum

# Create a new model
m = Model("optimization_problem")

# Create variables
potatoes = m.addVar(vtype=GRB.INTEGER, name="potatoes")
cherry_pies = m.addVar(vtype=GRB.INTEGER, name="cherry_pies")
rotisserie_chickens = m.addVar(vtype=GRB.INTEGER, name="rotisserie_chickens")
cantaloupes = m.addVar(vtype=GRB.INTEGER, name="cantaloupes")

# Set objective function
m.setObjective(6*potatoes**2 + 7*potatoes*rotisserie_chickens + 5*cherry_pies**2 + 4*cherry_pies*rotisserie_chickens + 2*rotisserie_chickens**2 + 6*rotisserie_chickens*cantaloupes + 5*cantaloupes**2 + potatoes, GRB.MAXIMIZE)

# Add constraints
m.addConstr(13*potatoes + 2*cantaloupes <= 21, "carbohydrate_constraint1")
m.addConstr(13*potatoes + 10*cherry_pies <= 46, "carbohydrate_constraint2")
m.addConstr(13*potatoes + 10*cherry_pies + 11*rotisserie_chickens + 2*cantaloupes <= 46, "carbohydrate_constraint3")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('potatoes:', potatoes.x)
    print('cherry_pies:', cherry_pies.x)
    print('rotisserie_chickens:', rotisserie_chickens.x)
    print('cantaloupes:', cantaloupes.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

