
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
potatoes = m.addVar(vtype=GRB.INTEGER, name="potatoes")
cherry_pies = m.addVar(vtype=GRB.INTEGER, name="cherry_pies")
rotisserie_chickens = m.addVar(vtype=GRB.INTEGER, name="rotisserie_chickens")
cantaloupes = m.addVar(vtype=GRB.INTEGER, name="cantaloupes")

# Objective function
m.setObjective(6 * potatoes**2 + 7 * potatoes * rotisserie_chickens + 
               5 * cherry_pies**2 + 4 * cherry_pies * rotisserie_chickens + 
               2 * rotisserie_chickens**2 + 6 * rotisserie_chickens * cantaloupes + 
               5 * cantaloupes**2 + potatoes, GRB.MAXIMIZE)

# Constraints
m.addConstr(13*potatoes + 10*cherry_pies + 11*rotisserie_chickens + 2*cantaloupes <= 61, "carb_total")
m.addConstr(13*potatoes + 2*cantaloupes <= 21, "carb_pot_cant")
m.addConstr(13*potatoes + 10*cherry_pies <= 46, "carb_pot_cherry")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Potatoes: {potatoes.x}")
    print(f"Cherry Pies: {cherry_pies.x}")
    print(f"Rotisserie Chickens: {rotisserie_chickens.x}")
    print(f"Cantaloupes: {cantaloupes.x}")
    print(f"Objective Function Value: {m.ObjVal}")
else:
    print("No optimal solution found")
