
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    potatoes = model.addVar(name="potatoes", vtype=gurobi.GRB.INTEGER)
    cherry_pies = model.addVar(name="cherry_pies", vtype=gurobi.GRB.INTEGER)
    rotisserie_chickens = model.addVar(name="rotisserie_chickens", vtype=gurobi.GRB.INTEGER)
    cantaloupes = model.addVar(name="cantaloupes", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(6 * potatoes**2 + 7 * potatoes * rotisserie_chickens + 5 * cherry_pies**2 + 
                       4 * cherry_pies * rotisserie_chickens + 2 * rotisserie_chickens**2 + 
                       6 * rotisserie_chickens * cantaloupes + 5 * cantaloupes**2 + potatoes, 
                       gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(13 * potatoes + 2 * cantaloupes <= 21)
    model.addConstr(13 * potatoes + 10 * cherry_pies <= 46)
    model.addConstr(13 * potatoes + 10 * cherry_pies + 11 * rotisserie_chickens + 2 * cantaloupes <= 46)

    # Non-negativity constraints (implicit for integer variables)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Potatoes: {potatoes.varValue}")
        print(f"Cherry Pies: {cherry_pies.varValue}")
        print(f"Rotisserie Chickens: {rotisserie_chickens.varValue}")
        print(f"Cantaloupes: {cantaloupes.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("The model is infeasible or unbounded.")

solve_optimization_problem()
