
from gurobipy import *

# Create a new model
model = Model("Nutrient_Optimization")

# Define decision variables
carbohydrates = model.addVar(lb=0, name="carbohydrates", vtype=GRB.CONTINUOUS)
fiber = model.addVar(lb=0, name="fiber", vtype=GRB.INTEGER)
vitamin_e = model.addVar(lb=0, name="vitamin_e", vtype=GRB.CONTINUOUS)
vitamin_b6 = model.addVar(lb=0, name="vitamin_b6", vtype=GRB.CONTINUOUS)
iron = model.addVar(lb=0, name="iron", vtype=GRB.CONTINUOUS)

# Objective: For simplicity, we'll just maximize the sum of all nutrients
model.setObjective(carbohydrates + fiber + vitamin_e + vitamin_b6 + iron, GRB.MAXIMIZE)

# Add constraints (example with a few)
# Energy stability indices
model.addConstr(3.5 * carbohydrates + 2.1 * fiber <= 58, name="energy_stability_1")
model.addConstr(vitamin_e + 4.2 * vitamin_b6 <= 55, name="energy_stability_2")

# Digestive support indices
model.addConstr(0.8 * fiber + 3.5 * vitamin_e <= 117, name="digestive_support_1")
model.addConstr(carbohydrates + 2.9 * fiber + 4.1 * vitamin_e + 2.6 * vitamin_b6 + 1.7 * iron <= 147, name="digestive_support_2")

# Immune support indices
model.addConstr(2.5 * carbohydrates + 3.8 * fiber + 2.9 * vitamin_e + 4.1 * vitamin_b6 + 2.7 * iron <= 51, name="immune_support_1")
model.addConstr(carbohydrates + 0.9 * fiber + 1.2 * vitamin_e + 2.5 * vitamin_b6 + 1.8 * iron <= 50, name="immune_support_2")

# Optimize the model
model.optimize()

# Print solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Carbohydrates: {carbohydrates.X}")
    print(f"Fiber: {fiber.X}")
    print(f"Vitamin E: {vitamin_e.X}")
    print(f"Vitamin B6: {vitamin_b6.X}")
    print(f"Iron: {iron.X}")
else:
    print("No optimal solution found")
