
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
b12 = m.addVar(lb=0, name="B12")  # milligrams of vitamin B12
b7 = m.addVar(lb=0, name="B7")  # milligrams of vitamin B7

# Set objective function
m.setObjective(9.14 * b12 + 5.53 * b7, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(11 * b12 + 10 * b7 >= 23, "cardio_support_min")
m.addConstr(12 * b12 + 3 * b7 >= 16, "energy_stability_min")
m.addConstr(4 * b12 - 3 * b7 >= 0, "b12_b7_relation")
m.addConstr(11 * b12 + 10 * b7 <= 49, "cardio_support_max") # Combined two identical constraints into one
m.addConstr(12 * b12 + 3 * b7 <= 50, "energy_stability_max") # Combined two identical constraints into one


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Milligrams of Vitamin B12: {b12.x}")
    print(f"Milligrams of Vitamin B7: {b7.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

