
import gurobi

def optimize_vitamins():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    vitamin_B12 = model.addVar(name="vitamin_B12", lb=0)  # Assuming non-negative
    vitamin_B7 = model.addVar(name="vitamin_B7", lb=0)  # Assuming non-negative

    # Objective function
    model.setObjective(9.14 * vitamin_B12 + 5.53 * vitamin_B7, gurobi.GRB.MAXIMIZE)

    # Constraints
    r0_B12 = 11
    r1_B12 = 12
    r0_B7 = 10
    r1_B7 = 3

    model.addConstr(r0_B12 + r0_B7 >= 23, name="cardiovascular_support_index_min")
    model.addConstr(r1_B12 + r1_B7 >= 16, name="energy_stability_index_min")
    model.addConstr(4 * vitamin_B12 - 3 * vitamin_B7 >= 0, name="vitamin_B12_B7_relation")
    model.addConstr(r0_B12 + r0_B7 <= 49, name="cardiovascular_support_index_max")
    model.addConstr(r1_B12 + r1_B7 <= 50, name="energy_stability_index_max")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B12: {vitamin_B12.varValue}")
        print(f"Milligrams of vitamin B7: {vitamin_B7.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_vitamins()
