
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_e = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_e")
vitamin_b6 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b6")

# Set objective function
m.setObjective(3 * vitamin_e + 2 * vitamin_b6, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(1.84 * vitamin_e + 1.53 * vitamin_b6 >= 39, "c1")
m.addConstr(-8 * vitamin_e + 9 * vitamin_b6 >= 0, "c2")
m.addConstr(1.84 * vitamin_e + 1.53 * vitamin_b6 <= 44, "c3")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal value: {m.objVal}")
    print(f"Milligrams of Vitamin E: {vitamin_e.x}")
    print(f"Milligrams of Vitamin B6: {vitamin_b6.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

