
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Define the variables
x0 = m.addVar(lb=0, name="milligrams_of_vitamin_E")  # Allow fractional amounts
x1 = m.addVar(lb=0, name="milligrams_of_vitamin_B6")  # Allow non-integer amounts

# Objective function: Minimize 3x0 + 2x1
m.setObjective(3*x0 + 2*x1, GRB.MINIMIZE)

# Constraints
m.addConstr(1.84*x0 + 1.53*x1 >= 39, name="min_cardiovascular_support")
m.addConstr(-8*x0 + 9*x1 >= 0, name="linear_constraint")
m.addConstr(1.84*x0 + 1.53*x1 <= 44, name="max_cardiovascular_support")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin E: {x0.x}")
    print(f"Milligrams of Vitamin B6: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
