
import gurobipy as gp

def solve_optimization_problem():
    # Create a new model
    model = gp.Model("vitamin_optimization")

    # Define the variables
    x0 = model.addVar(name="milligrams_of_vitamin_E", lb=0)  # Assuming non-negative
    x1 = model.addVar(name="milligrams_of_vitamin_B6", lb=0)  # Assuming non-negative

    # Objective function: Minimize 3 * x0 + 2 * x1
    model.setObjective(3 * x0 + 2 * x1, gp.GRB.MINIMIZE)

    # Constraints
    model.addConstr(1.84 * x0 + 1.53 * x1 >= 39, name="min_cardiovascular_support")
    model.addConstr(-8 * x0 + 9 * x1 >= 0, name="vitamin_interaction_constraint")
    model.addConstr(1.84 * x0 + 1.53 * x1 <= 83, name="max_cardiovascular_support")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gp.GRB.OPTIMAL:
        print(f"Optimal solution found: x0 = {x0.varValue}, x1 = {x1.varValue}")
        print(f"Objective value: {model.objVal}")
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible")
    else:
        print("The model has a non-optimal status")

solve_optimization_problem()
