
from gurobipy import Model, GRB, quicksum

# Create a new model
m = Model("minimize_work_hours")

# Create variables
mary_hours = m.addVar(lb=0, name="mary_hours")  # Mary's hours worked
george_hours = m.addVar(lb=0, name="george_hours")  # George's hours worked

# Set objective function
m.setObjective(
    1 * mary_hours * mary_hours
    + 6 * mary_hours * george_hours
    + 2 * george_hours * george_hours
    + 6 * mary_hours
    + 8 * george_hours,
    GRB.MINIMIZE,
)

# Add constraints

# Work quality rating constraints
m.addConstr(12 * mary_hours * mary_hours + 20 * george_hours * george_hours >= 38, "work_quality_squared")
m.addConstr(12 * mary_hours + 20 * george_hours >= 38, "work_quality_linear")
m.addConstr(12 * mary_hours * mary_hours + 20 * george_hours * george_hours <= 55, "work_quality_squared_upper")


# Productivity rating constraints
m.addConstr(2 * mary_hours * mary_hours + 12 * george_hours * george_hours >= 28, "productivity_squared")
m.addConstr(2 * mary_hours + 12 * george_hours >= 28, "productivity_linear")
m.addConstr(2 * mary_hours + 12 * george_hours <= 52, "productivity_linear_upper")


# Additional constraint
m.addConstr(-10 * mary_hours + 7 * george_hours >= 0, "additional_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: Mary's hours = {mary_hours.x}, George's hours = {george_hours.x}")
    print(f"Objective value: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

