
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
mary_hours = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Mary")
george_hours = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_George")

# Objective function
m.setObjective(1 * mary_hours**2 + 6 * mary_hours * george_hours + 2 * george_hours**2 + 6 * mary_hours + 8 * george_hours, GRB.MINIMIZE)

# Constraints
m.addConstr(12 * mary_hours >= 38, "work_quality_mary")
m.addConstr(20 * george_hours >= 38, "work_quality_george")
m.addConstr(144 * mary_hours**2 + 400 * george_hours**2 >= 38, "total_work_quality_squared")
m.addConstr(2 * mary_hours + 12 * george_hours >= 28, "productivity_rating")
m.addConstr(4 * mary_hours**2 + 144 * george_hours**2 >= 28, "total_productivity_squared")
m.addConstr(-10 * mary_hours + 7 * george_hours >= 0, "hours_relationship")
m.addConstr(144 * mary_hours**2 + 400 * george_hours**2 <= 55, "max_total_work_quality_squared")
m.addConstr(2 * mary_hours + 12 * george_hours <= 52, "max_productivity_rating")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Hours worked by Mary:", mary_hours.x)
    print("Hours worked by George:", george_hours.x)
else:
    print("No optimal solution found")
