
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
x0 = m.addVar(name="hours_worked_by_Mary", lb=0)  # Assuming non-negative hours
x1 = m.addVar(name="hours_worked_by_George", lb=0)  # Assuming non-negative hours

# Objective function
m.setObjective(x0**2 + 6*x0*x1 + 2*x1**2 + 6*x0 + 8*x1)

# Constraints
m.addConstr(12*x0 <= 84, name="Mary_work_quality_rating")
m.addConstr(2*x0 <= 92, name="Mary_productivity_rating")
m.addConstr(20*x1 <= 84, name="George_work_quality_rating")
m.addConstr(12*x1 <= 92, name="George_productivity_rating")

m.addConstr(12*x0**2 + 20*x1**2 >= 38, name="combined_work_quality_rating_squared")
m.addConstr(12*x0 + 20*x1 >= 38, name="combined_work_quality_rating")

m.addConstr(2*x0**2 + 12*x1**2 >= 28, name="combined_productivity_rating_squared")
m.addConstr(2*x0 + 12*x1 >= 28, name="combined_productivity_rating")

m.addConstr(-10*x0 + 7*x1 >= 0, name="hourly_work_constraint")

m.addConstr(12*x0**2 + 20*x1**2 <= 55, name="combined_work_quality_rating_squared_upper")
m.addConstr(2*x0 + 12*x1 <= 52, name="combined_productivity_rating_upper")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB_OPTIMAL:
    print("Optimal Solution:")
    print(f"Hours worked by Mary: {x0.varValue}")
    print(f"Hours worked by George: {x1.varValue}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("The model is infeasible or unbounded.")
