
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
bill_hours = m.addVar(vtype=GRB.INTEGER, name="bill_hours")
dale_hours = m.addVar(vtype=GRB.CONTINUOUS, name="dale_hours")
mary_hours = m.addVar(vtype=GRB.CONTINUOUS, name="mary_hours")

# Set objective function
m.setObjective(5*bill_hours*bill_hours + 2*bill_hours*dale_hours + 4*bill_hours*mary_hours + 2*dale_hours*dale_hours + 3*bill_hours + dale_hours, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7 * dale_hours + 7 * mary_hours >= 13, "c1")
m.addConstr(5 * bill_hours + 7 * dale_hours >= 28, "c2")
m.addConstr(6 * dale_hours + 3 * mary_hours >= 8, "c3")
m.addConstr(1 * bill_hours + 3 * mary_hours >= 8, "c4")
m.addConstr(5 * bill_hours * bill_hours + 7 * dale_hours * dale_hours <= 67, "c5")
m.addConstr(5 * bill_hours + 7 * mary_hours <= 31, "c6")
m.addConstr(5 * bill_hours + 7 * dale_hours + 7 * mary_hours <= 31, "c7")
m.addConstr(1 * bill_hours + 6 * dale_hours <= 21, "c8")
m.addConstr(1 * bill_hours + 6 * dale_hours + 3 * mary_hours <= 21, "c9")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Bill Hours: %g' % bill_hours.x)
    print('Dale Hours: %g' % dale_hours.x)
    print('Mary Hours: %g' % mary_hours.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
