
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
B = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Bill")
D = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Dale")
M = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Mary")

# Objective function
m.setObjective(5*B**2 + 2*B*D + 4*B*M + 2*D**2 + 3*B + D, GRB.MAXIMIZE)

# Constraints
# Productivity ratings
m.addConstr(B * 5 <= 92, name="Bill_Productivity")
m.addConstr(D * 7 <= 92, name="Dale_Productivity")
m.addConstr(M * 7 <= 92, name="Mary_Productivity")

# Work quality ratings
m.addConstr(B * 1 <= 34, name="Bill_Work_Quality")
m.addConstr(D * 6 <= 34, name="Dale_Work_Quality")
m.addConstr(M * 3 <= 34, name="Mary_Work_Quality")

# Combined productivity rating constraints
m.addConstr(D*7 + M*7 >= 13, name="Combined_Productivity_D_M")
m.addConstr(B*5 + D*7 >= 28, name="Combined_Productivity_B_D")
m.addConstr(B*5 + M*7 <= 31, name="Combined_Productivity_B_M_Limit")
m.addConstr(B*5 + D*7 + M*7 <= 31, name="Total_Combined_Productivity_Limit")

# Combined work quality rating constraints
m.addConstr(D*6 + M*3 >= 8, name="Combined_Work_Quality_D_M")
m.addConstr(B*1 + M*3 >= 8, name="Combined_Work_Quality_B_M")
m.addConstr(B*1 + D*6 <= 21, name="Combined_Work_Quality_B_D_Limit")
m.addConstr(B*1 + D*6 + M*3 <= 21, name="Total_Combined_Work_Quality_Limit")

# Productivity squared constraint
m.addConstr(B**2 * 5 + D**2 * 7 <= 67, name="Productivity_Squared_Limit")

# Optimize the model
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
print("Objective:", m.objVal)
