
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x_B = m.addVar(name="hours_worked_by_Bill", vtype=gp.GRB.INTEGER)
x_D = m.addVar(name="hours_worked_by_Dale")
x_M = m.addVar(name="hours_worked_by_Mary")

# Objective function
m.setObjective(5*x_B**2 + 2*x_B*x_D + 4*x_B*x_M + 2*x_D**2 + 3*x_B + x_D, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(5 * x_B <= 92, name="Bill_productivity")
m.addConstr(x_B >= 0, name="Bill_productivity_nonneg")
m.addConstr(1 * x_B <= 34, name="Bill_work_quality")
m.addConstr(7 * x_D <= 92, name="Dale_productivity")
m.addConstr(x_D >= 0, name="Dale_productivity_nonneg")
m.addConstr(6 * x_D <= 34, name="Dale_work_quality")
m.addConstr(7 * x_M <= 92, name="Mary_productivity")
m.addConstr(x_M >= 0, name="Mary_productivity_nonneg")
m.addConstr(3 * x_M <= 34, name="Mary_work_quality")
m.addConstr(7 * x_D + 7 * x_M >= 13, name="Dale_Mary_productivity")
m.addConstr(5 * x_B + 7 * x_D >= 28, name="Bill_Dale_productivity")
m.addConstr(6 * x_D + 3 * x_M >= 8, name="Dale_Mary_work_quality")
m.addConstr(1 * x_B + 3 * x_M >= 8, name="Bill_Mary_work_quality")
m.addConstr(25 * x_B**2 + 49 * x_D**2 <= 67, name="Bill_Dale_productivity_squared")
m.addConstr(5 * x_B + 7 * x_M <= 31, name="Bill_Mary_productivity_limit")
m.addConstr(5 * x_B + 7 * x_D + 7 * x_M <= 31, name="total_productivity_limit")
m.addConstr(1 * x_B + 6 * x_D <= 21, name="Bill_Dale_work_quality_limit")
m.addConstr(1 * x_B + 6 * x_D + 3 * x_M <= 21, name="total_work_quality_limit")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Bill: ", x_B.varValue)
    print("Hours worked by Dale: ", x_D.varValue)
    print("Hours worked by Mary: ", x_M.varValue)
else:
    print("The model is infeasible")
