
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="rotisserie_chickens", lb=0)
x1 = m.addVar(name="bowls_of_cereal", lb=0)
x2 = m.addVar(name="corn_cobs", lb=0)
x3 = m.addVar(name="milkshakes", lb=0)
x4 = m.addVar(name="cheeseburgers", lb=0)
x5 = m.addVar(name="cantaloupes", lb=0)

# Define the objective function
m.setObjective(7.25*x0**2 + 6.35*x0*x1 + 3.97*x1**2 + 2.57*x1*x2 + 9.82*x1*x4 + 9.52*x1*x5 + 
               10.0*x2*x3 + 3.0*x4*x5 + 1.28*x0 + 9.11*x2 + 5.08*x4, gp.GRB.MINIMIZE)

# Grams of fat constraints
m.addConstr(16*x0 + 4*x1 + 22*x2 + 8*x3 + x4 + 6*x5 <= 289, "fat_constraint")
m.addConstr(4*x1 + 22*x2 >= 43, "fat_from_cereal_and_corn")
m.addConstr(x2**2 + x4**2 >= 33, "fat_from_corn_and_cheeseburgers")
m.addConstr(16*x0 + 22*x2 >= 21, "fat_from_chickens_and_corn")
m.addConstr(4*x1 + 8*x3 >= 24, "fat_from_cereal_and_milkshakes")
m.addConstr(16*x0 + x4 >= 19, "fat_from_chickens_and_cheeseburgers")
m.addConstr(22*x2 + 6*x5 >= 40, "fat_from_corn_and_cantaloupes")

# Sourness index constraints
m.addConstr(x0 + x5**2 >= 24, "sourness_from_chickens_and_cantaloupes")
m.addConstr(x2 + x3 >= 40, "sourness_from_corn_and_milkshakes")
m.addConstr(x0 + x3 >= 18, "sourness_from_chickens_and_milkshakes")
m.addConstr(x0 + x1 + x2 + x3 + x4 + x5 >= 18, "sourness_from_all")

# Healthiness rating constraints
m.addConstr(x0**2 + x2**2 >= 40, "healthiness_from_chickens_and_corn")
m.addConstr(x0**2 + x3**2 >= 32, "healthiness_from_chickens_and_milkshakes")
m.addConstr(x0**2 + x5**2 >= 42, "healthiness_from_chickens_and_cantaloupes")
m.addConstr(x4 + x5 >= 26, "healthiness_from_cheeseburgers_and_cantaloupes")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Rotisserie chickens: ", x0.varValue)
    print("Bowls of cereal: ", x1.varValue)
    print("Corn cobs: ", x2.varValue)
    print("Milkshakes: ", x3.varValue)
    print("Cheeseburgers: ", x4.varValue)
    print("Cantaloupes: ", x5.varValue)
else:
    print("No optimal solution found")
