
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
vitamin_b4 = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_b4")
vitamin_b3 = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_b3")
protein = m.addVar(vtype=gp.GRB.INTEGER, name="protein")
vitamin_c = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_c")

# Set objective function
m.setObjective(9*vitamin_b4**2 + 6*vitamin_b4*vitamin_b3 + 2*vitamin_b4*protein + 4*vitamin_b4*vitamin_c + 8*vitamin_b3**2 + 9*vitamin_b3*protein + 4*vitamin_b3*vitamin_c + 3*protein**2 + 8*protein*vitamin_c + 8*vitamin_c**2 + 8*vitamin_b4 + 5*vitamin_b3 + 7*protein + 9*vitamin_c, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(27*vitamin_b4 + 11*vitamin_b3 + 15*protein + 18*vitamin_c <= 238, "r0") # Energy stability index
m.addConstr(1*vitamin_b4 + 26*vitamin_b3 + 15*protein + 2*vitamin_c <= 272, "r1") # Cardiovascular support index

m.addConstr(27*vitamin_b4 + 11*vitamin_b3 >= 19, "c1")
m.addConstr(11*vitamin_b3 + 15*protein >= 24, "c2")
m.addConstr(11*vitamin_b3 + 18*vitamin_c >= 29, "c3")
m.addConstr(27*vitamin_b4 + 15*protein >= 33, "c4")
m.addConstr(27*vitamin_b4 + 15*protein + 18*vitamin_c >= 56, "c5")
m.addConstr(27*vitamin_b4 + 11*vitamin_b3 + 15*protein >= 56, "c6")
m.addConstr(27*vitamin_b4 + 15*protein + 18*vitamin_c >= 54, "c7")
m.addConstr(27*vitamin_b4 + 11*vitamin_b3 + 15*protein >= 54, "c8")
m.addConstr(27*vitamin_b4 + 11*vitamin_b3 + 15*protein + 18*vitamin_c >= 54, "c9")

m.addConstr(1*vitamin_b4 + 15*protein >= 38, "c10")
m.addConstr(15*protein + 2*vitamin_c >= 56, "c11")
m.addConstr(1*vitamin_b4 + 26*vitamin_b3 + 2*vitamin_c >= 53, "c12")
m.addConstr(1*vitamin_b4 + 26*vitamin_b3 + 15*protein + 2*vitamin_c >= 53, "c13")

m.addConstr(7*protein**2 - 4*vitamin_c**2 >= 0, "c14")
m.addConstr(-10*vitamin_b4 + 9*vitamin_c >= 0, "c15")
m.addConstr(15*protein**2 + 18*vitamin_c**2 <= 108, "c16")
m.addConstr(27*vitamin_b4 + 18*vitamin_c <= 207, "c17")
m.addConstr(11*vitamin_b3 + 15*protein <= 121, "c18")
m.addConstr(27*vitamin_b4 + 15*protein <= 118, "c19")
m.addConstr(27*vitamin_b4 + 15*protein + 18*vitamin_c <= 80, "c20")
m.addConstr(27*vitamin_b4 + 11*vitamin_b3 + 18*vitamin_c <= 151, "c21")


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

