
from gurobi import *

# Create a new model
m = Model()

# Define the variables
postage_stamps = m.addVar(name="postage_stamps", vtype=GRB.INTEGER)
manila_envelopes = m.addVar(name="manila_envelopes", vtype=GRB.INTEGER)
3D_printers = m.addVar(name="3D_printers", vtype=GRB.INTEGER)
packs_of_paper = m.addVar(name="packs_of_paper", vtype=GRB.INTEGER)
lanyards = m.addVar(name="lanyards", vtype=GRB.INTEGER)
paper_clips = m.addVar(name="paper_clips", vtype=GRB.INTEGER)
red_pens = m.addVar(name="red_pens", vtype=GRB.INTEGER)
color_printers = m.addVar(name="color_printers", vtype=GRB.INTEGER)

# Objective function
m.setObjective(8 * postage_stamps + 7 * manila_envelopes + 5 * 3D_printers + 5 * packs_of_paper + 9 * lanyards + 8 * paper_clips + 2 * red_pens + color_printers, GRB.MAXIMIZE)

# Constraints
# Usefulness ratings
m.addConstr(postage_stamps * 13 <= 296)
m.addConstr(manila_envelopes * 7 <= 296)
m.addConstr(3D_printers * 1 <= 296)
m.addConstr(packs_of_paper * 6 <= 296)
m.addConstr(lanyards * 8 <= 296)
m.addConstr(paper_clips * 8 <= 296)
m.addConstr(red_pens * 11 <= 296)
m.addConstr(color_printers * 6 <= 296)

# Weights
m.addConstr(postage_stamps * 5 <= 214)
m.addConstr(manila_envelopes * 2 <= 214)
m.addConstr(3D_printers * 6 <= 214)
m.addConstr(packs_of_paper * 3 <= 214)
m.addConstr(lanyards * 5 <= 214)
m.addConstr(paper_clips * 2 <= 214)
m.addConstr(red_pens * 9 <= 214)
m.addConstr(color_printers * 11 <= 214)

# Individual usefulness ratings
m.addConstr(postage_stamps * 13 >= 13)
m.addConstr(manila_envelopes * 7 >= 7)
m.addConstr(3D_printers * 1 >= 1)
m.addConstr(packs_of_paper * 6 >= 6)
m.addConstr(lanyards * 8 >= 8)
m.addConstr(paper_clips * 8 >= 8)
m.addConstr(red_pens * 11 >= 11)
m.addConstr(color_printers * 6 >= 6)

# Combined usefulness ratings
m.addConstr(postage_stamps * 13 + 3D_printers * 1 >= 16)
m.addConstr(3D_printers * 1 + packs_of_paper * 6 >= 33)
m.addConstr(manila_envelopes * 7 + paper_clips * 8 >= 19)
m.addConstr(lanyards * 8 + red_pens * 11 >= 18)
m.addConstr(postage_stamps * 13 + lanyards * 8 >= 17)
m.addConstr(manila_envelopes * 7 + packs_of_paper * 6 >= 19)
m.addConstr(packs_of_paper * 6 + lanyards * 8 >= 21)
m.addConstr(packs_of_paper * 6 + paper_clips * 8 >= 18)
m.addConstr(paper_clips * 8 + color_printers * 6 >= 13)
m.addConstr(manila_envelopes * 7 + packs_of_paper * 6 + lanyards * 8 >= 24)
m.addConstr(postage_stamps * 13 + 3D_printers * 1 + paper_clips * 8 >= 24)
m.addConstr(postage_stamps * 13 + manila_envelopes * 7 + red_pens * 11 >= 24)
m.addConstr(manila_envelopes * 7 + paper_clips * 8 + color_printers * 6 >= 24)
m.addConstr(packs_of_paper * 6 + lanyards * 8 + color_printers * 6 >= 24)
m.addConstr(lanyards * 8 + red_pens * 11 + color_printers * 6 >= 24)
m.addConstr(3D_printers * 1 + paper_clips * 8 + red_pens * 11 >= 24)
m.addConstr(manila_envelopes * 7 + 3D_printers * 1 + packs_of_paper * 6 >= 24)
m.addConstr(manila_envelopes * 7 + 3D_printers * 1 + color_printers * 6 >= 24)
m.addConstr(postage_stamps * 13 + 3D_printers * 1 + color_printers * 6 >= 24)
m.addConstr(packs_of_paper * 6 + lanyards * 8 + paper_clips * 8 >= 24)
m.addConstr(3D_printers * 1 + packs_of_paper * 6 + paper_clips * 8 >= 24)
m.addConstr(postage_stamps * 13 + paper_clips * 8 + color_printers * 6 >= 24)
m.addConstr(postage_stamps * 13 + packs_of_paper * 6 + lanyards * 8 >= 24)
m.addConstr(postage_stamps * 13 + manila_envelopes * 7 + lanyards * 8 >= 24)
m.addConstr(manila_envelopes * 7 + lanyards * 8 + color_printers * 6 >= 24)
m.addConstr(manila_envelopes * 7 + packs_of_paper * 6 + lanyards * 8 >= 32)

# Solve the problem
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Postage stamps: ", postage_stamps.varValue)
    print("Manila envelopes: ", manila_envelopes.varValue)
    print("3D printers: ", 3D_printers.varValue)
    print("Packs of paper: ", packs_of_paper.varValue)
    print("Lanyards: ", lanyards.varValue)
    print("Paper clips: ", paper_clips.varValue)
    print("Red pens: ", red_pens.varValue)
    print("Color printers: ", color_printers.varValue)
else:
    print("No solution found")
