
from gurobipy import Model, GRB

# Create a new model
m = Model("resource_optimization")

# Create variables
pen_testers = m.addVar(vtype=GRB.INTEGER, name="pen_testers")
intrusion_analysts = m.addVar(vtype=GRB.INTEGER, name="intrusion_analysts")

# Set objective function
m.setObjective(5.33 * pen_testers**2 + 7.9 * intrusion_analysts**2 + 3.3 * pen_testers, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15 * pen_testers + 18 * intrusion_analysts <= 129, "power_consumption_upper_bound")  # Resource r0
m.addConstr(10 * pen_testers + 7 * intrusion_analysts <= 176, "dollar_cost_upper_bound")  # Resource r1
m.addConstr(8 * pen_testers + 7 * intrusion_analysts <= 244, "network_latency_impact_upper_bound")  # Resource r2
m.addConstr(13 * pen_testers + 6 * intrusion_analysts <= 309, "data_confidentiality_impact_upper_bound")  # Resource r3
m.addConstr(9 * pen_testers + 20 * intrusion_analysts <= 192, "network_integrity_impact_upper_bound")  # Resource r4

m.addConstr((15 * pen_testers)**2 + (18 * intrusion_analysts)**2 >= 22, "power_consumption_squared_lower_bound")
m.addConstr(10 * pen_testers + 7 * intrusion_analysts >= 63, "dollar_cost_lower_bound")
m.addConstr(8 * pen_testers + 7 * intrusion_analysts >= 88, "network_latency_impact_lower_bound")
m.addConstr(13 * pen_testers + 6 * intrusion_analysts >= 81, "data_confidentiality_impact_lower_bound")
m.addConstr(9 * pen_testers + 20 * intrusion_analysts >= 91, "network_integrity_impact_lower_bound")

m.addConstr(9 * pen_testers - 3 * intrusion_analysts >= 0, "linear_constraint")
m.addConstr(15 * pen_testers + 18 * intrusion_analysts <= 68, "power_consumption_upper_bound_2")
m.addConstr(10 * pen_testers**2 + 7 * intrusion_analysts**2 <= 143, "dollar_cost_squared_upper_bound")
m.addConstr(10 * pen_testers + 7 * intrusion_analysts <= 143, "dollar_cost_upper_bound_2")
m.addConstr(8 * pen_testers + 7 * intrusion_analysts <= 213, "network_latency_impact_upper_bound_2")
m.addConstr(13 * pen_testers + 6 * intrusion_analysts <= 157, "data_confidentiality_impact_upper_bound_2")
m.addConstr(9 * pen_testers**2 + 20 * intrusion_analysts**2 <= 192, "network_integrity_impact_squared_upper_bound")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('pen_testers:', pen_testers.x)
    print('intrusion_analysts:', intrusion_analysts.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

