
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
pen_testers = m.addVar(name="pen_testers", vtype=gp.GRB.INTEGER)
intrusion_analysts = m.addVar(name="intrusion_analysts", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(5.33 * pen_testers**2 + 7.9 * intrusion_analysts**2 + 3.3 * pen_testers, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(15 * pen_testers + 18 * intrusion_analysts <= 129, name="power_consumption")
m.addConstr(10 * pen_testers <= 176, name="dollar_cost_pen_testers")
m.addConstr(7 * intrusion_analysts <= 176, name="dollar_cost_intrusion_analysts")
m.addConstr(8 * pen_testers + 7 * intrusion_analysts >= 88, name="network_latency")
m.addConstr(13 * pen_testers + 6 * intrusion_analysts >= 81, name="data_confidentiality")
m.addConstr(9 * pen_testers + 20 * intrusion_analysts >= 91, name="network_integrity")
m.addConstr(9 * pen_testers - 3 * intrusion_analysts >= 0, name="pen_testers_intrusion_analysts_constraint")
m.addConstr(15 * pen_testers + 18 * intrusion_analysts <= 68, name="total_power_consumption")
m.addConstr(10 * pen_testers + 7 * intrusion_analysts >= 63, name="total_dollar_cost")
m.addConstr(10 * pen_testers + 7 * intrusion_analysts <= 143, name="total_dollar_cost_limit")
m.addConstr(8 * pen_testers + 7 * intrusion_analysts <= 213, name="network_latency_limit")
m.addConstr(13 * pen_testers + 6 * intrusion_analysts <= 157, name="data_confidentiality_limit")
m.addConstr(9 * pen_testers + 20 * intrusion_analysts <= 192, name="network_integrity_limit")
m.addConstr((15 * pen_testers)**2 + (18 * intrusion_analysts)**2 >= 22, name="power_consumption_squared")

# Optimize the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Pen testers:", pen_testers.varValue)
    print("Intrusion analysts:", intrusion_analysts.varValue)
    print("Objective:", m.objVal)
else:
    print("The model is infeasible")
