
from gurobipy import Model, GRB

# Create a new model
model = Model("WorkOptimization")

# Create variables
ringo_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ringo_hours")
laura_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="laura_hours")
mary_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="mary_hours")

# Set objective function
model.setObjective(7 * ringo_hours + 4 * laura_hours + 1 * mary_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(4 * ringo_hours + 7 * laura_hours >= 19, "c1")
model.addConstr(4 * ringo_hours + 2 * mary_hours >= 18, "c2")
model.addConstr(7 * laura_hours + 2 * mary_hours >= 8, "c3")
model.addConstr(4 * ringo_hours + 7 * laura_hours + 2 * mary_hours >= 8, "c4")

model.addConstr(7 * ringo_hours + 2 * laura_hours >= 15, "c5")
model.addConstr(7 * ringo_hours + 1 * mary_hours >= 8, "c6")
model.addConstr(7 * ringo_hours + 2 * laura_hours + 1 * mary_hours >= 8, "c7")

model.addConstr(3 * ringo_hours + 5 * laura_hours >= 17, "c8")
model.addConstr(5 * laura_hours + 5 * mary_hours >= 6, "c9")
model.addConstr(3 * ringo_hours + 5 * laura_hours + 5 * mary_hours >= 6, "c10")

model.addConstr(5 * laura_hours - 9 * mary_hours >= 0, "c11")
model.addConstr(-6 * ringo_hours + 2 * laura_hours >= 0, "c12")

model.addConstr(4 * ringo_hours + 2 * mary_hours <= 46, "c13")
model.addConstr(3 * ringo_hours + 5 * laura_hours <= 20, "c14")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Ringo Hours: %g' % ringo_hours.x)
    print('Laura Hours: %g' % laura_hours.x)
    print('Mary Hours: %g' % mary_hours.x)
elif model.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % model.status)

