
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
R = m.addVar(lb=0, name="Ringo_hours")  # hours worked by Ringo
L = m.addVar(lb=0, name="Laura_hours")  # hours worked by Laura
M = m.addVar(lb=0, name="Mary_hours")  # hours worked by Mary

# Define the objective function
m.setObjective(7*R + 4*L + M, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(4*R + 7*L + 2*M <= 60)  # work quality rating constraint
m.addConstr(7*R + 2*L + M <= 63)  # productivity rating constraint
m.addConstr(3*R + 5*L + 5*M <= 59)  # paperwork competence rating constraint
m.addConstr(4*R + 7*L >= 19)  # combined work quality rating constraint for Ringo and Laura
m.addConstr(4*R + 2*M >= 18)  # combined work quality rating constraint for Ringo and Mary
m.addConstr(7*L + 2*M >= 8)  # combined work quality rating constraint for Laura and Mary
m.addConstr(4*R + 7*L + 2*M >= 8)  # combined work quality rating constraint for all
m.addConstr(7*R + 2*L >= 15)  # combined productivity rating constraint for Ringo and Laura
m.addConstr(7*R + M >= 8)  # combined productivity rating constraint for Ringo and Mary
m.addConstr(7*R + 2*L + M >= 8)  # combined productivity rating constraint for all
m.addConstr(3*R + 5*L >= 17)  # combined paperwork competence rating constraint for Ringo and Laura
m.addConstr(5*L + 5*M >= 6)  # combined paperwork competence rating constraint for Laura and Mary
m.addConstr(3*R + 5*L + 5*M >= 6)  # combined paperwork competence rating constraint for all
m.addConstr(5*L - 9*M >= 0)  # constraint involving Laura and Mary
m.addConstr(-6*R + 2*L >= 0)  # constraint involving Ringo and Laura
m.addConstr(4*R + 2*M <= 46)  # upper limit on combined work quality rating for Ringo and Mary
m.addConstr(3*R + 5*L <= 20)  # upper limit on combined paperwork competence rating for Ringo and Laura

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Ringo hours: {R.varValue}")
    print(f"Laura hours: {L.varValue}")
    print(f"Mary hours: {M.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
