
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
milkshakes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milkshakes")
chicken_thighs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_thighs")
oreos = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oreos")
granola_bars = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="granola_bars")

# Set objective function
m.setObjective(6 * milkshakes + 2 * chicken_thighs + 8 * oreos + 6 * granola_bars, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * milkshakes + 6 * chicken_thighs + 7 * oreos + 6 * granola_bars <= 144, "protein_limit") #r0
m.addConstr(9 * milkshakes + 7 * chicken_thighs + 2 * oreos + 10 * granola_bars <= 134, "cost_limit") #r1

m.addConstr(6 * chicken_thighs + 6 * granola_bars >= 36, "protein_constraint1")
m.addConstr(7 * oreos + 6 * granola_bars >= 36, "protein_constraint2")
m.addConstr(4 * milkshakes + 6 * chicken_thighs + 6 * granola_bars >= 18, "protein_constraint3")
m.addConstr(9 * milkshakes + 10 * granola_bars >= 25, "cost_constraint1")
m.addConstr(7 * oreos + 6 * granola_bars <= 88, "protein_constraint4")
m.addConstr(4 * milkshakes + 6 * granola_bars <= 131, "protein_constraint5")
m.addConstr(4 * milkshakes + 6 * chicken_thighs <= 116, "protein_constraint6")
m.addConstr(6 * chicken_thighs + 6 * granola_bars <= 137, "protein_constraint7")
m.addConstr(4 * milkshakes + 6 * chicken_thighs + 7 * oreos <= 49, "protein_constraint8")
m.addConstr(4 * milkshakes + 7 * oreos + 6 * granola_bars <= 105, "protein_constraint9")
m.addConstr(4 * milkshakes + 6 * chicken_thighs + 7 * oreos + 6 * granola_bars <= 105, "protein_constraint10")
m.addConstr(9 * milkshakes + 10 * granola_bars <= 40, "cost_constraint2")
m.addConstr(7 * chicken_thighs + 10 * granola_bars <= 45, "cost_constraint3")
m.addConstr(9 * milkshakes + 2 * oreos <= 87, "cost_constraint4")
m.addConstr(9 * milkshakes + 2 * oreos + 10 * granola_bars <= 47, "cost_constraint5")
m.addConstr(9 * milkshakes + 7 * chicken_thighs + 2 * oreos + 10 * granola_bars <= 47, "cost_constraint6")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

