
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
milkshakes = model.addVar(name="milkshakes", lb=0)
chicken_thighs = model.addVar(name="chicken_thighs", lb=0)
oreos = model.addVar(name="oreos", lb=0)
granola_bars = model.addVar(name="granola_bars", lb=0)

# Objective function
model.setObjective(6 * milkshakes + 2 * chicken_thighs + 8 * oreos + 6 * granola_bars, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(6 * chicken_thighs + 6 * granola_bars >= 36)
model.addConstr(7 * oreos + 6 * granola_bars >= 36)
model.addConstr(4 * milkshakes + 6 * chicken_thighs + 6 * granola_bars >= 18)
model.addConstr(9 * milkshakes + 10 * granola_bars >= 25)
model.addConstr(7 * oreos + 6 * granola_bars <= 88)
model.addConstr(4 * milkshakes + 6 * granola_bars <= 131)
model.addConstr(4 * milkshakes + 6 * chicken_thighs <= 116)
model.addConstr(6 * chicken_thighs + 6 * granola_bars <= 137)
model.addConstr(4 * milkshakes + 6 * chicken_thighs + 7 * oreos <= 49)
model.addConstr(4 * milkshakes + 7 * oreos + 6 * granola_bars <= 105)
model.addConstr(4 * milkshakes + 6 * chicken_thighs + 7 * oreos + 6 * granola_bars <= 105)
model.addConstr(9 * milkshakes + 10 * granola_bars <= 40)
model.addConstr(7 * chicken_thighs + 10 * granola_bars <= 45)
model.addConstr(9 * milkshakes + 2 * oreos <= 87)
model.addConstr(9 * milkshakes + 2 * oreos + 10 * granola_bars <= 47)
model.addConstr(9 * milkshakes + 7 * chicken_thighs + 2 * oreos + 10 * granola_bars <= 47)

# Allow for non-integer solutions
milkshakes.Integrality = 0
chicken_thighs.Integrality = 0
oreos.Integrality = 0
granola_bars.Integrality = 0

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.Status.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Milkshakes: ", milkshakes.x)
    print("Chicken Thighs: ", chicken_thighs.x)
    print("Oreos: ", oreos.x)
    print("Granola Bars: ", granola_bars.x)
else:
    print("The model is infeasible")
