
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, name="rotisserie_chickens")  # Rotisserie chickens
x1 = m.addVar(lb=0, name="strawberries")  # Strawberries
x2 = m.addVar(lb=0, name="kale_salads")  # Kale salads

# Set objective function
m.setObjective(1.86 * x0**2 + 3.99 * x0 * x1 + 3.25 * x0 * x2 + 9.37 * x1 * x2 + 9.46 * x2**2 + 3.19 * x1 + 5.67 * x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1 * x0 + 13 * x1 + 6 * x2 <= 122, "protein_limit")  # Total protein constraint
m.addConstr(8 * x0 + 6 * x1 + 9 * x2 <= 117, "calcium_limit")  # Total calcium constraint

m.addConstr((1*x0)**2 + (13*x1)**2 >= 16, "protein_squared_lower_bound")
m.addConstr((1*x0)**2 + (6*x2)**2 <= 118, "protein_squared_upper_bound")

m.addConstr(8 * x0 + 6 * x1 <= 117, "calcium_x0_x1")
m.addConstr(6 * x1 + 9 * x2 <= 82, "calcium_x1_x2")
m.addConstr(8 * x0 + 9 * x2 <= 117, "calcium_x0_x2")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Rotisserie Chickens:', x0.x)
    print('Strawberries:', x1.x)
    print('Kale Salads:', x2.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

