
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, name="rotisserie_chickens")
x1 = m.addVar(lb=0, name="strawberries")
x2 = m.addVar(lb=0, name="kale_salads")

# Objective function
m.setObjective(1.86*x0**2 + 3.99*x0*x1 + 3.25*x0*x2 + 9.37*x1*x2 + 9.46*x2**2 + 3.19*x1 + 5.67*x2, GRB.MAXIMIZE)

# Constraints
m.addConstr(x0**2 + x1**2 >= 16, name="protein_from_rotisserie_and_strawberries")
m.addConstr(x0**2 + x2**2 <= 118, name="total_protein_from_rotisserie_and_kale")
m.addConstr(1*x0 + 13*x1 + 6*x2 <= 122, name="total_protein")
m.addConstr(8*x0 + 6*x1 <= 117, name="calcium_from_rotisserie_and_strawberries")
m.addConstr(6*x1 + 9*x2 <= 82, name="calcium_from_strawberries_and_kale")
m.addConstr(8*x0 + 9*x2 <= 117, name="calcium_from_rotisserie_and_kale")
m.addConstr(8*x0 + 6*x1 + 9*x2 <= 117, name="total_calcium")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Rotisserie Chickens: {x0.x}")
    print(f"Strawberries: {x1.x}")
    print(f"Kale Salads: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found.")
