
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define variables
rotisserie_chickens = m.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="rotisserie_chickens")
strawberries = m.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="strawberries")
kale_salads = m.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="kale_salads")

# Define objective function
m.setObjective(1.86 * rotisserie_chickens ** 2 + 3.99 * rotisserie_chickens * strawberries + 3.25 * rotisserie_chickens * kale_salads + 
               9.37 * strawberries * kale_salads + 9.46 * kale_salads ** 2 + 3.19 * strawberries + 5.67 * kale_salads, 
               gurobi.GRB.MAXIMIZE)

# Define constraints
m.addConstr(rotisserie_chickens ** 2 + strawberries ** 2 >= 16, name="protein_constraint_1")
m.addConstr(rotisserie_chickens ** 2 + kale_salads ** 2 <= 118, name="protein_constraint_2")
m.addConstr(rotisserie_chickens + 13 * strawberries + 6 * kale_salads <= 122, name="protein_constraint_3")

m.addConstr(8 * rotisserie_chickens + 6 * strawberries <= 117, name="calcium_constraint_1")
m.addConstr(6 * strawberries + 9 * kale_salads <= 82, name="calcium_constraint_2")
m.addConstr(8 * rotisserie_chickens + 9 * kale_salads <= 117, name="calcium_constraint_3")
m.addConstr(8 * rotisserie_chickens + 6 * strawberries + 9 * kale_salads <= 117, name="calcium_constraint_4")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Rotisserie chickens:", rotisserie_chickens.varValue)
    print("Strawberries:", strawberries.varValue)
    print("Kale salads:", kale_salads.varValue)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found.")
