
import gurobi as gp

m = gp.Model("optimization_problem")

x0 = m.addVar(name="ham_sandwiches", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="potatoes")
x2 = m.addVar(name="tomatoes")
x3 = m.addVar(name="blueberry_pies", vtype=gp.GRB.INTEGER)
x4 = m.addVar(name="milkshakes", vtype=gp.GRB.INTEGER)

m.setObjective(3.25*x0 + 8.27*x1 + 4.04*x2 + 2.37*x3 + 2.22*x4, gp.GRB.MINIMIZE)

# Resource constraints
m.addConstr(19*x0 + 8*x1 + 1*x2 + 7*x3 + 3*x4 <= 227)
m.addConstr(11*x0 + 23*x1 + 17*x2 + 3*x3 + 12*x4 <= 212)
m.addConstr(5*x0 + 10*x1 + 19*x2 + 13*x3 + 14*x4 <= 214)
m.addConstr(11*x0 + 17*x1 + 2*x2 + 1*x3 + 20*x4 <= 358)

# Individual item constraints
m.addConstr(x0 >= 0)
m.addConstr(x1 >= 0)
m.addConstr(x2 >= 0)
m.addConstr(x3 >= 0)
m.addConstr(x4 >= 0)

# Combined tastiness constraints
m.addConstr(1*x2 + 7*x3 >= 16)
m.addConstr(19*x0 + 1*x2 >= 42)
m.addConstr(8*x1 + 1*x2 >= 34)
m.addConstr(7*x3 + 3*x4 >= 21)
m.addConstr(8*x1 + 3*x4 >= 17)
m.addConstr(1*x2 + 3*x4 >= 43)
m.addConstr(8*x1 + 7*x3 >= 30)
m.addConstr(19*x0 + 3*x4 >= 34)
m.addConstr(19*x0 + 7*x3 + 3*x4 >= 30)
m.addConstr(19*x0 + 1*x2 + 7*x3 >= 30)
m.addConstr(19*x0 + 8*x1 + 3*x4 >= 30)
m.addConstr(8*x1 + 7*x3 + 3*x4 >= 42)
m.addConstr(19*x0 + 7*x3 + 3*x4 >= 42)
m.addConstr(19*x0 + 1*x2 + 7*x3 >= 42)
m.addConstr(19*x0 + 8*x1 + 3*x4 >= 42)
m.addConstr(8*x1 + 7*x3 + 3*x4 >= 42)
m.addConstr(8*x1 + 7*x3 + 3*x4 >= 37)
m.addConstr(19*x0 + 7*x3 + 3*x4 >= 37)
m.addConstr(19*x0 + 1*x2 + 7*x3 >= 37)
m.addConstr(19*x0 + 8*x1 + 3*x4 >= 37)
m.addConstr(19*x0 + 8*x1 + 7*x3 >= 37)
m.addConstr(8*x1 + 7*x3 + 3*x4 >= 35)
m.addConstr(19*x0 + 7*x3 + 3*x4 >= 35)
m.addConstr(19*x0 + 1*x2 + 7*x3 >= 35)
m.addConstr(19*x0 + 8*x1 + 3*x4 >= 35)
m.addConstr(19*x0 + 8*x1 + 7*x3 >= 35)
m.addConstr(8*x1 + 7*x3 + 3*x4 >= 31)
m.addConstr(19*x0 + 7*x3 + 3*x4 >= 31)
m.addConstr(19*x0 + 1*x2 + 7*x3 >= 31)
m.addConstr(19*x0 + 8*x1 + 3*x4 >= 31)
m.addConstr(19*x0 + 8*x1 + 7*x3 >= 31)
m.addConstr(19*x0 + 1*x2 + 3*x4 + 8*x1 + 7*x3 >= 31)

# Calcium constraints
m.addConstr(11*x0 + 17*x2 >= 38)
m.addConstr(11*x0 + 3*x3 >= 16)
m.addConstr(23*x1 + 3*x3 >= 33)
m.addConstr(23*x1 + 12*x4 >= 40)
m.addConstr(11*x0 + 23*x1 >= 30)
m.addConstr(3*x3 + 12*x4 >= 28)
m.addConstr(17*x2 + 3*x3 + 12*x4 >= 25)
m.addConstr(23*x1 + 17*x2 + 3*x3 >= 25)
m.addConstr(11*x0 + 3*x3 + 12*x4 >= 25)
m.addConstr(11*x0 + 23*x1 + 12*x4 >= 25)
m.addConstr(11*x0 + 17*x2 + 12*x4 >= 25)
m.addConstr(23*x1 + 17*x2 + 12*x4 >= 25)
m.addConstr(23*x1 + 3*x3 + 12*x4 >= 25)
m.addConstr(11*x0 + 17*x2 + 3*x3 >= 25)
m.addConstr(11*x0 + 23*x1 + 17*x2 >= 25)
m.addConstr(17*x2 + 3*x3 + 12*x4 >= 36)
m.addConstr(23*x1 + 17*x2 + 3*x3 >= 36)
m.addConstr(11*x0 + 3*x3 + 12*x4 >= 36)
m.addConstr(11*x0 + 23*x1 + 12*x4 >= 36)
m.addConstr(11*x0 + 17*x2 + 12*x4 >= 36)
m.addConstr(11*x0 + 23*x1 + 17*x2 >= 36)
m.addConstr(23*x1 + 17*x2 + 12*x4 >= 36)
m.addConstr(23*x1 + 3*x3 + 12*x4 >= 36)
m.addConstr(11*x0 + 23*x1 + 17*x2 >= 37)
m.addConstr(23*x1 + 17*x2 + 3*x3 >= 37)
m.addConstr(11*x0 + 3*x3 + 12*x4 >= 37)
m.addConstr(11*x0 + 23*x1 + 12*x4 >= 37)
m.addConstr(11*x0 + 17*x2 + 12*x4 >= 37)

# Protein constraints
m.addConstr(10*x1 + 19*x2 >= 15)
m.addConstr(10*x1 + 14*x4 >= 23)
m.addConstr(5*x0 + 14*x4 >= 41)
m.addConstr(5*x0 + 10*x1 + 19*x2 + 13*x3 + 14*x4 >= 41)

# Fat constraints
m.addConstr(17*x1 + 2*x2 >= 25)
m.addConstr(11*x0 + 17*x1 + 2*x2 + 1*x3 + 20*x4 >= 25)

# Bounds
m.addConstr(19*x0 + 1*x2 <= 179)
m.addConstr(19*x0 + 8*x1 <= 143)
m.addConstr(1*x2 + 3*x4 <= 125)
m.addConstr(8*x1 + 3*x4 <= 153)
m.addConstr(1*x2 + 7*x3 <= 169)
m.addConstr(19*x0 + 7*x3 <= 121)
m.addConstr(19*x0 + 3*x4 <= 78)
m.addConstr(1*x2 + 7*x3 + 3*x4 <= 60)

m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("ham sandwiches: ", x0.varValue)
    print("potatoes: ", x1.varValue)
    print("tomatoes: ", x2.varValue)
    print("blueberry pies: ", x3.varValue)
    print("milkshakes: ", x4.varValue)
else:
    print("The model is infeasible")
