
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
oreos = m.addVar(lb=0, name="oreos")
bacon = m.addVar(lb=0, name="bacon")
cheeseburgers = m.addVar(lb=0, name="cheeseburgers")
cherry_pies = m.addVar(lb=0, name="cherry_pies")

# Set objective function
m.setObjective(9.32 * oreos + 7.86 * bacon + 6.97 * cheeseburgers + 5.41 * cherry_pies, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(1.37 * oreos + 0.58 * bacon >= 18, "calcium_constraint1")
m.addConstr(0.58 * bacon + 1.27 * cherry_pies >= 40, "calcium_constraint2")
m.addConstr(1.37 * oreos + 2.62 * cheeseburgers >= 31, "calcium_constraint3")
m.addConstr(1.37 * oreos + 1.27 * cherry_pies >= 23, "calcium_constraint4")
m.addConstr(0.58 * bacon + 2.62 * cheeseburgers >= 39, "calcium_constraint5")
m.addConstr(1.37 * oreos + 0.58 * bacon + 2.62 * cheeseburgers + 1.27 * cherry_pies >= 39, "calcium_constraint6")
m.addConstr(2.62 * cheeseburgers + 1.27 * cherry_pies <= 161, "calcium_constraint7")
m.addConstr(1.37 * oreos + 0.58 * bacon + 2.62 * cheeseburgers + 1.27 * cherry_pies <= 193, "calcium_constraint8")


m.addConstr(2.19 * bacon + 1.36 * cheeseburgers >= 33, "iron_constraint1")
m.addConstr(2.7 * oreos + 1.67 * cherry_pies >= 98, "iron_constraint2")
m.addConstr(2.7 * oreos + 1.36 * cheeseburgers >= 61, "iron_constraint3")
m.addConstr(1.36 * cheeseburgers + 1.67 * cherry_pies >= 44, "iron_constraint4")
m.addConstr(2.7 * oreos + 2.19 * bacon + 1.36 * cheeseburgers + 1.67 * cherry_pies >= 44, "iron_constraint5")
m.addConstr(2.7 * oreos + 2.19 * bacon + 1.67 * cherry_pies <= 227, "iron_constraint6")
m.addConstr(2.7 * oreos + 2.19 * bacon + 1.36 * cheeseburgers <= 305, "iron_constraint7")
m.addConstr(2.7 * oreos + 1.36 * cheeseburgers + 1.67 * cherry_pies <= 384, "iron_constraint8")
m.addConstr(2.19 * bacon + 1.36 * cheeseburgers + 1.67 * cherry_pies <= 200, "iron_constraint9")
m.addConstr(2.7 * oreos + 2.19 * bacon + 1.36 * cheeseburgers + 1.67 * cherry_pies <= 399, "iron_constraint10")


m.addConstr(10 * oreos - 6 * cheeseburgers >= 0, "constraint1")
m.addConstr(-8 * oreos + 9 * bacon >= 0, "constraint2")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Oreos:', oreos.x)
    print('Bacon:', bacon.x)
    print('Cheeseburgers:', cheeseburgers.x)
    print('Cherry Pies:', cherry_pies.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

