
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
oreos = m.addVar(name="oreos", lb=-gp.GRB.INFINITY)
strips_of_bacon = m.addVar(name="strips of bacon", lb=-gp.GRB.INFINITY)
cheeseburgers = m.addVar(name="cheeseburgers", lb=-gp.GRB.INFINITY)
cherry_pies = m.addVar(name="cherry pies", lb=-gp.GRB.INFINITY)

# Define the objective function
m.setObjective(9.32 * oreos + 7.86 * strips_of_bacon + 6.97 * cheeseburgers + 5.41 * cherry_pies, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(1.37 * oreos + 0.58 * strips_of_bacon <= 193)
m.addConstr(2.7 * oreos + 2.19 * strips_of_bacon + 1.36 * cheeseburgers + 1.67 * cherry_pies <= 399)
m.addConstr(1.37 * oreos + 0.58 * strips_of_bacon >= 18)
m.addConstr(0.58 * strips_of_bacon + 1.27 * cherry_pies >= 40)
m.addConstr(1.37 * oreos + 2.62 * cheeseburgers >= 31)
m.addConstr(1.37 * oreos + 1.27 * cherry_pies >= 23)
m.addConstr(0.58 * strips_of_bacon + 2.62 * cheeseburgers >= 39)
m.addConstr(1.37 * oreos + 0.58 * strips_of_bacon + 2.62 * cheeseburgers + 1.27 * cherry_pies >= 39)
m.addConstr(2.19 * strips_of_bacon + 1.36 * cheeseburgers >= 33)
m.addConstr(2.7 * oreos + 1.67 * cherry_pies >= 98)
m.addConstr(2.7 * oreos + 1.36 * cheeseburgers >= 61)
m.addConstr(1.36 * cheeseburgers + 1.67 * cherry_pies >= 44)
m.addConstr(2.7 * oreos + 2.19 * strips_of_bacon + 1.36 * cheeseburgers + 1.67 * cherry_pies >= 44)
m.addConstr(10 * oreos - 6 * cheeseburgers >= 0)
m.addConstr(-8 * oreos + 9 * strips_of_bacon >= 0)
m.addConstr(2.62 * cheeseburgers + 1.27 * cherry_pies <= 161)
m.addConstr(2.7 * oreos + 2.19 * strips_of_bacon + 1.67 * cherry_pies <= 227)
m.addConstr(2.7 * oreos + 2.19 * strips_of_bacon + 1.36 * cheeseburgers <= 305)
m.addConstr(2.7 * oreos + 1.36 * cheeseburgers + 1.67 * cherry_pies <= 384)
m.addConstr(2.19 * strips_of_bacon + 1.36 * cheeseburgers + 1.67 * cherry_pies <= 200)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Oreos: ", oreos.varValue)
    print("Strips of bacon: ", strips_of_bacon.varValue)
    print("Cheeseburgers: ", cheeseburgers.varValue)
    print("Cherry pies: ", cherry_pies.varValue)
else:
    print("The model is infeasible")
