
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
potatoes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potatoes")
milkshakes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milkshakes")
protein_bars = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein_bars")
hot_dogs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hot_dogs")

# Set objective function
m.setObjective(5.19 * potatoes**2 + 6.13 * potatoes * milkshakes + 5.47 * potatoes * protein_bars + 9.83 * potatoes * hot_dogs + 7.3 * milkshakes**2 + 4.72 * milkshakes * protein_bars + 3.82 * protein_bars**2 + 8.95 * hot_dogs**2 + 6.59 * potatoes + 6.2 * hot_dogs, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3 * potatoes**2 + 1 * protein_bars**2 >= 30, "tastiness_constraint1")
m.addConstr(8 * milkshakes + 4 * hot_dogs >= 28, "tastiness_constraint2")
m.addConstr(3 * potatoes + 8 * milkshakes + 1 * protein_bars + 4 * hot_dogs >= 28, "tastiness_constraint3")
m.addConstr(3 * potatoes + 1 * protein_bars <= 61, "tastiness_constraint4")
m.addConstr(3 * potatoes + 8 * milkshakes <= 62, "tastiness_constraint5")
m.addConstr(3 * potatoes + 4 * hot_dogs <= 127, "tastiness_constraint6")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('potatoes:', potatoes.x)
    print('milkshakes:', milkshakes.x)
    print('protein_bars:', protein_bars.x)
    print('hot_dogs:', hot_dogs.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

