
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    P = model.addVar(lb=0, name="potatoes", vtype=gurobi.GRB.CONTINUOUS)
    M = model.addVar(lb=0, name="milkshakes", vtype=gurobi.GRB.CONTINUOUS)
    B = model.addVar(lb=0, name="protein_bars", vtype=gurobi.GRB.CONTINUOUS)
    H = model.addVar(lb=0, name="hot_dogs", vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(5.19*P**2 + 6.13*P*M + 5.47*P*B + 9.83*P*H + 
                       7.3*M**2 + 4.72*M*B + 3.82*B**2 + 8.95*H**2 + 
                       6.59*P + 6.2*H, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstraint(3**2 * P + 1**2 * B >= 30, name="tastiness_rating_1")
    model.addConstraint(8 * M + 4 * H >= 28, name="tastiness_rating_2")
    model.addConstraint(3 * P + 8 * M + 1 * B + 4 * H >= 28, name="tastiness_rating_3")
    model.addConstraint(3 * P + 1 * B <= 61, name="tastiness_rating_4")
    model.addConstraint(3 * P + 8 * M <= 62, name="tastiness_rating_5")
    model.addConstraint(3 * P + 4 * H <= 127, name="tastiness_rating_6")

    # Update model
    model.update()

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Potatoes: {P.varValue}")
        print(f"Milkshakes: {M.varValue}")
        print(f"Protein Bars: {B.varValue}")
        print(f"Hot Dogs: {H.varValue}")
        print(f"Objective Function Value: {model.objVal}")
    else:
        print("The model is infeasible.")

optimize_problem()
