
from gurobipy import Model, GRB, quicksum

# Create a new model
m = Model("optimization_problem")

# Create variables
vitamin_b1 = m.addVar(vtype=GRB.INTEGER, name="vitamin_b1")  # Integer
protein = m.addVar(vtype=GRB.INTEGER, name="protein")  # Integer
fiber = m.addVar(vtype=GRB.CONTINUOUS, name="fiber")  # Continuous

# Set objective function
obj = 7 * vitamin_b1**2 + 9 * vitamin_b1 * protein + 4 * vitamin_b1 * fiber + 4 * protein**2 + 8 * protein * fiber + 1 * fiber**2 + 8 * vitamin_b1 + 4 * protein + 1 * fiber
m.setObjective(obj, GRB.MINIMIZE)

# Add constraints
kidney_support_index = {'r0': {'upper_bound': 93, 'x0': 9, 'x1': 7, 'x2': 10}}

m.addConstr(9 * vitamin_b1 + 7 * protein + 10 * fiber <= kidney_support_index['r0']['upper_bound'], "kidney_support_index_upper_bound")
m.addConstr(9 * vitamin_b1 + 10 * fiber >= 16, "kidney_support_combined1")
m.addConstr(9 * vitamin_b1 + 7 * protein >= 19, "kidney_support_combined2")
m.addConstr(9 * vitamin_b1 + 7 * protein + 10 * fiber >= 19, "kidney_support_combined3")
m.addConstr(9**2 * vitamin_b1**2 + 7**2 * protein**2 + 10**2 * fiber**2 <= 73, "kidney_support_combined4")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('vitamin_b1:', vitamin_b1.x)
    print('protein:', protein.x)
    print('fiber:', fiber.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
