
import gurobi as gp

# Create a new model
m = gp.Model("Optimization_Problem")

# Define variables
mg_B1 = m.addVar(name="mg_B1", vtype=gp.GRB.INTEGER)  # integer
g_protein = m.addVar(name="g_protein", vtype=gp.GRB.CONTINUOUS)  # non-fractional, so continuous but will be enforced
g_fiber = m.addVar(name="g_fiber", vtype=gp.GRB.CONTINUOUS)  # can be fractional

# Objective function
m.setObjective(7 * mg_B1 ** 2 + 9 * mg_B1 * g_protein + 4 * mg_B1 * g_fiber + 
               4 * g_protein ** 2 + 8 * g_protein * g_fiber + 1 * g_fiber ** 2 + 
               8 * mg_B1 + 4 * g_protein + 1 * g_fiber, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(mg_B1 == 9, name="kidney_support_B1")
m.addConstr(g_protein == 7, name="kidney_support_protein")
m.addConstr(g_fiber == 10, name="kidney_support_fiber")

# Since mg_B1, g_protein, g_fiber have fixed values from constraints, 
# constraints 4, 5, 6 are automatically satisfied or not needed.

# Constraint 7: sum of squares of indices
m.addConstr(9 ** 2 + 7 ** 2 + 10 ** 2 <= 73, name="sum_squares_indices")

# Solve the problem
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin B1: {mg_B1.varValue}")
    print(f"Grams of protein: {g_protein.varValue}")
    print(f"Grams of fiber: {g_fiber.varValue}")
    print(f"Objective value: {m.objVal}")
else:
    print("No optimal solution found.")
