
from gurobipy import Model, GRB

# Create a new model
model = Model("vitamin_optimization")

# Create variables
vitamin_c = model.addVar(vtype=GRB.INTEGER, name="vitamin_c")  # Integer amount
vitamin_b4 = model.addVar(vtype=GRB.CONTINUOUS, name="vitamin_b4")

# Set objective function
model.setObjective(2.04 * vitamin_c + 8.38 * vitamin_b4, GRB.MAXIMIZE)

# Add constraints
model.addConstr(0.24 * vitamin_c + 0.73 * vitamin_b4 >= 20, "immune_support_min")
model.addConstr(0.03 * vitamin_c + 0.9 * vitamin_b4 >= 27, "kidney_support_min")
model.addConstr(4 * vitamin_c - 2 * vitamin_b4 >= 0, "vitamin_ratio")
model.addConstr(0.24 * vitamin_c + 0.73 * vitamin_b4 <= 36, "immune_support_max")
model.addConstr(0.03 * vitamin_c + 0.9 * vitamin_b4 <= 51, "kidney_support_max")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Milligrams of Vitamin C: {vitamin_c.x}")
    print(f"Milligrams of Vitamin B4: {vitamin_b4.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

