
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_C")  # Non-fractional amount of vitamin C
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B4")  # Fractional amount allowed for vitamin B4

# Define the objective function
m.setObjective(2.04*x0 + 8.38*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.24*x0 + 0.73*x1 >= 20, name="immune_support_min")
m.addConstr(0.24*x0 + 0.73*x1 <= 36, name="immune_support_max")
m.addConstr(0.03*x0 + 0.9*x1 >= 27, name="kidney_support_min")
m.addConstr(0.03*x0 + 0.9*x1 <= 51, name="kidney_support_max")
m.addConstr(4*x0 - 2*x1 >= 0, name="vitamin_ratio")

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
print("Objective:", m.objVal)
