
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
# Vitamin C in milligrams (integer)
vitamin_C = model.addVar(name="vitamin_C", vtype=gurobi.GRB.INTEGER)
# Vitamin B4 in milligrams (continuous)
vitamin_B4 = model.addVar(name="vitamin_B4")

# Objective function: Maximize 2.04 * vitamin_C + 8.38 * vitamin_B4
model.setObjective(2.04 * vitamin_C + 8.38 * vitamin_B4, gurobi.GRB.MAXIMIZE)

# Constraints
# Immune support index: 0.24 * vitamin_C + 0.73 * vitamin_B4 >= 20
model.addConstr(0.24 * vitamin_C + 0.73 * vitamin_B4 >= 20, name="immune_support_min")
# Immune support index: 0.24 * vitamin_C + 0.73 * vitamin_B4 <= 36
model.addConstr(0.24 * vitamin_C + 0.73 * vitamin_B4 <= 36, name="immune_support_max")
# Kidney support index: 0.03 * vitamin_C + 0.9 * vitamin_B4 >= 27
model.addConstr(0.03 * vitamin_C + 0.9 * vitamin_B4 >= 27, name="kidney_support_min")
# Kidney support index: 0.03 * vitamin_C + 0.9 * vitamin_B4 <= 51
model.addConstr(0.03 * vitamin_C + 0.9 * vitamin_B4 <= 51, name="kidney_support_max")
# 4 * vitamin_C - 2 * vitamin_B4 >= 0
model.addConstr(4 * vitamin_C - 2 * vitamin_B4 >= 0, name="vitamin_balance")

# Optimize the model
model.optimize()

# Print the results
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Vitamin C: {vitamin_C.varValue} mg")
    print(f"Vitamin B4: {vitamin_B4.varValue} mg")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
