
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_d = m.addVar(lb=0, name="vitamin_d")  # Continuous
vitamin_b4 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_b4")
vitamin_b12 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_b12")

# Set objective function
m.setObjective(4 * vitamin_d**2 + 7 * vitamin_d * vitamin_b4 + 5 * vitamin_b4 * vitamin_b12 + 9 * vitamin_d + 6 * vitamin_b12, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(8 * vitamin_d + 6 * vitamin_b4 >= 4, "c1")
m.addConstr(8 * vitamin_d + 6 * vitamin_b4 + 4 * vitamin_b12 >= 5, "c2")
m.addConstr(8 * vitamin_d + 4 * vitamin_b12 <= 27, "c3")
m.addConstr(8 * vitamin_d + 6 * vitamin_b4 <= 17, "c4")
m.addConstr(6 * vitamin_b4 + 4 * vitamin_b12 <= 21, "c5")
m.addConstr(8 * vitamin_d + 6 * vitamin_b4 + 4 * vitamin_b12 <= 21, "c6")
m.addConstr(3 * vitamin_d + 2 * vitamin_b4 <= 15, "c7")
m.addConstr(3 * vitamin_d + 7 * vitamin_b12 <= 22, "c8")
m.addConstr(3 * vitamin_d + 2 * vitamin_b4 + 7 * vitamin_b12 <= 22, "c9")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('vitamin_d:', vitamin_d.x)
    print('vitamin_b4:', vitamin_b4.x)
    print('vitamin_b12:', vitamin_b12.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

