
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Define variables
x0 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_D")
x1 = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_B4")
x2 = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_B12")

# Objective function
m.setObjective(4*x0**2 + 7*x0*x1 + 5*x1*x2 + 9*x0 + 6*x2, GRB.MAXIMIZE)

# Constraints
# Minimum total cardiovascular support index from milligrams of vitamin D and B4
m.addConstr(8*x0 + 6*x1 >= 4, name="min_cardio_support_D_B4")

# Minimum total cardiovascular support index from milligrams of vitamin D, B4, and B12
m.addConstr(8*x0 + 6*x1 + 4*x2 >= 5, name="min_cardio_support_D_B4_B12")

# Maximum total cardiovascular support index from milligrams of vitamin D and B12
m.addConstr(8*x0 + 4*x2 <= 27, name="max_cardio_support_D_B12")

# Maximum total cardiovascular support index from milligrams of vitamin D and B4
m.addConstr(8*x0 + 6*x1 <= 17, name="max_cardio_support_D_B4")

# Maximum total cardiovascular support index from milligrams of vitamin B4 and B12
m.addConstr(6*x1 + 4*x2 <= 21, name="max_cardio_support_B4_B12")

# Maximum total cardiovascular support index from all vitamins
m.addConstr(8*x0 + 6*x1 + 4*x2 <= 21, name="max_total_cardio_support")

# Maximum total digestive support index from milligrams of vitamin D and B4
m.addConstr(3*x0 + 2*x1 <= 15, name="max_digestive_support_D_B4")

# Maximum total digestive support index from milligrams of vitamin D and B12
m.addConstr(3*x0 + 7*x2 <= 22, name="max_digestive_support_D_B12")

# Maximum total digestive support index from all vitamins
m.addConstr(3*x0 + 2*x1 + 7*x2 <= 22, name="max_total_digestive_support")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin D: {x0.x}")
    print(f"Milligrams of Vitamin B4: {x1.x}")
    print(f"Milligrams of Vitamin B12: {x2.x}")
else:
    print("No optimal solution found")
