
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-float('inf'), ub=float('inf'), name="milligrams of vitamin D")
    x1 = model.addVar(lb=-float('inf'), ub=float('inf'), vtype=gurobi.GRB.INTEGER, name="milligrams of vitamin B4")
    x2 = model.addVar(lb=-float('inf'), ub=float('inf'), vtype=gurobi.GRB.INTEGER, name="milligrams of vitamin B12")

    # Objective function
    model.setObjective(4*x0**2 + 7*x0*x1 + 5*x1*x2 + 9*x0 + 6*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(8*x0 + 6*x1 >= 4, name="cardiovascular support index 1")
    model.addConstr(8*x0 + 6*x1 + 4*x2 >= 5, name="cardiovascular support index 2")
    model.addConstr(8*x0 + 4*x2 <= 27, name="cardiovascular support index 3")
    model.addConstr(8*x0 + 6*x1 <= 17, name="cardiovascular support index 4")
    model.addConstr(6*x1 + 4*x2 <= 21, name="cardiovascular support index 5")
    model.addConstr(8*x0 + 6*x1 + 4*x2 <= 21, name="cardiovascular support index 6")
    model.addConstr(3*x0 + 2*x1 <= 15, name="digestive support index 1")
    model.addConstr(3*x0 + 7*x2 <= 22, name="digestive support index 2")
    model.addConstr(3*x0 + 2*x1 + 7*x2 <= 22, name="digestive support index 3")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Milligrams of vitamin D: ", x0.varValue)
        print("Milligrams of vitamin B4: ", x1.varValue)
        print("Milligrams of vitamin B12: ", x2.varValue)
    else:
        print("No optimal solution found")

solve_optimization_problem()
