
from gurobipy import Model, GRB

# Create a new model
m = Model("data_integrity_optimization")

# Create variables
monitoring = m.addVar(vtype=GRB.INTEGER, name="x0")
pen_testers = m.addVar(vtype=GRB.INTEGER, name="x1")
security_onions = m.addVar(vtype=GRB.INTEGER, name="x2")
automatic_alerts = m.addVar(vtype=GRB.INTEGER, name="x3")
system_admins = m.addVar(vtype=GRB.INTEGER, name="x4")

# Set objective function
m.setObjective(8 * monitoring + 6 * pen_testers + 6 * security_onions + automatic_alerts + 3 * system_admins, GRB.MINIMIZE)

# Add constraints
m.addConstr(19 * pen_testers + 12 * automatic_alerts >= 70)
m.addConstr(19 * pen_testers + 28 * security_onions >= 97)
m.addConstr(8 * monitoring + 12 * automatic_alerts >= 69)
m.addConstr(28 * security_onions + 12 * automatic_alerts >= 101)
m.addConstr(12 * automatic_alerts + 27 * system_admins >= 100)
m.addConstr(8 * monitoring + 27 * system_admins >= 138)
m.addConstr(19 * pen_testers + 12 * automatic_alerts + 27 * system_admins >= 144)
m.addConstr(28 * security_onions + 12 * automatic_alerts + 27 * system_admins >= 144)
m.addConstr(8 * monitoring + 28 * security_onions + 27 * system_admins >= 144)
m.addConstr(8 * monitoring + 19 * pen_testers + 12 * automatic_alerts >= 144)
m.addConstr(8 * monitoring + 12 * automatic_alerts + 27 * system_admins >= 144)
m.addConstr(19 * pen_testers + 28 * security_onions + 12 * automatic_alerts >= 144)
m.addConstr(8 * monitoring + 19 * pen_testers + 28 * security_onions >= 144)
m.addConstr(19 * pen_testers + 28 * security_onions + 27 * system_admins >= 144)
m.addConstr(8 * monitoring + 28 * security_onions + 12 * automatic_alerts >= 144)

#Simplified/removed redundant constraints below this line.  Many of the constraints for 83, 96, 110, 111, 130, 131, 133 were redundant with the 144 constraints.
m.addConstr(19 * pen_testers + 12 * automatic_alerts + 27 * system_admins >= 131)
m.addConstr(28 * security_onions + 12 * automatic_alerts + 27 * system_admins >= 131)
m.addConstr(19 * pen_testers + 12 * automatic_alerts + 27 * system_admins >= 152)
m.addConstr(28 * security_onions + 12 * automatic_alerts + 27 * system_admins >= 152)
m.addConstr(8 * monitoring + 28 * security_onions + 27 * system_admins >= 83)
m.addConstr(8 * monitoring + 19 * pen_testers + 12 * automatic_alerts + 27 * system_admins >= 83) #Combined constraint
m.addConstr(-7 * pen_testers + 5 * automatic_alerts >= 0)
m.addConstr(-3 * monitoring + 3 * pen_testers + 3 * system_admins >= 0)
m.addConstr(28 * security_onions + 12 * automatic_alerts <= 575)
m.addConstr(19 * pen_testers + 27 * system_admins <= 396)
m.addConstr(28 * security_onions + 27 * system_admins <= 428)
m.addConstr(8 * monitoring + 19 * pen_testers <= 384)
m.addConstr(8 * monitoring + 19 * pen_testers + 12 * automatic_alerts <= 543)
m.addConstr(19 * pen_testers + 28 * security_onions + 12 * automatic_alerts <= 161)
m.addConstr(8 * monitoring + 28 * security_onions + 12 * automatic_alerts <= 587)
m.addConstr(28 * security_onions + 12 * automatic_alerts + 27 * system_admins <= 485)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)
