
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
bacon = m.addVar(vtype=gp.GRB.INTEGER, name="strips_of_bacon")
oranges = m.addVar(vtype=gp.GRB.CONTINUOUS, name="oranges")

# Set objective function
m.setObjective(1.28 * bacon**2 + 3.91 * oranges**2 + 8.56 * bacon + 5.2 * oranges, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(8 * bacon + 3 * oranges >= 14, "fiber_minimum")
m.addConstr(4 * bacon - 6 * oranges >= 0, "bacon_orange_ratio")
m.addConstr(8 * bacon**2 + 3 * oranges**2 <= 15, "fiber_squared_maximum") # Note: Fiber content applies to squared quantities as well.
m.addConstr(8 * bacon + 3 * oranges <= 15, "fiber_maximum")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Strips of bacon: {bacon.x}")
    print(f"Oranges: {oranges.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

