
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="strips_of_bacon")  # Integer variable for strips of bacon
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="oranges")  # Continuous variable for oranges

# Objective function: Maximize
m.setObjective(1.28*x0**2 + 3.91*x1**2 + 8.56*x0 + 5.2*x1, GRB.MAXIMIZE)

# Constraints
m.addConstr(8*x0 + 3*x1 >= 14, name="min_fiber")  # Minimum fiber constraint
m.addConstr(4*x0 - 6*x1 >= 0, name="bacon_orange_ratio")  # Bacon to orange ratio constraint
m.addConstr((8*x0**2 + 3*x1**2) <= 15, name="max_fiber_squared")  # Maximum fiber from squares
m.addConstr(8*x0 + 3*x1 <= 15, name="max_fiber_linear")  # Maximum fiber linear constraint

# Optimize the model
m.optimize()

# Print results if optimized successfully
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Strips of bacon: {x0.X}")
    print(f"Oranges: {x1.X}")
    print(f"Objective function value: {m.ObjVal}")
else:
    print("No optimal solution found")
