
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="strips_of_bacon", vtype=gurobi.GRB.INTEGER)  # integer variable for strips of bacon
    x1 = model.addVar(name="oranges", vtype=gurobi.GRB.CONTINUOUS)  # continuous variable for oranges

    # Objective function
    model.setObjective(1.28 * x0**2 + 3.91 * x1**2 + 8.56 * x0 + 5.2 * x1, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(8 * x0 + 3 * x1 >= 14, name="fiber_min")  # at least 14 grams of fiber
    model.addConstr(4 * x0 - 6 * x1 >= 0, name="bacon_orange_balance")  # four times bacon - six times oranges >= 0
    model.addConstr(8**2 * x0**2 + 3**2 * x1**2 <= 15, name="fiber_squared_max")  # up to 15 grams of fiber squared
    model.addConstr(8 * x0 + 3 * x1 <= 15, name="fiber_max")  # at most 15 grams of fiber

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Strips of bacon: {x0.varValue}")
        print(f"Oranges: {x1.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
