
from gurobipy import Model, GRB

# Create a new model
model = Model("Supplement_Optimization")

# Create variables
vitamin_b9 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b9")
magnesium = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="magnesium")
vitamin_b7 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b7")

# Set objective function
model.setObjective(7 * vitamin_b9 + 2 * magnesium + 2 * vitamin_b7, GRB.MINIMIZE)

# Add constraints based on provided resources and attributes
r = {'r0': {'description': 'muscle growth index', 'upper_bound': 73, 'x0': 11, 'x1': 3, 'x2': 11}, 
     'r1': {'description': 'immune support index', 'upper_bound': 91, 'x0': 7, 'x1': 10, 'x2': 8}, 
     'r2': {'description': 'cognitive performance index', 'upper_bound': 91, 'x0': 4, 'x1': 2, 'x2': 5}}

# Muscle growth index constraints
model.addConstr(11 * vitamin_b9 + 11 * vitamin_b7 >= 23)
model.addConstr(11 * vitamin_b9 + 3 * magnesium >= 8)
model.addConstr(11 * vitamin_b9 + 3 * magnesium + 11 * vitamin_b7 >= 8)
model.addConstr(11 * vitamin_b9 + 3 * magnesium <= 70)
model.addConstr(3 * magnesium + 11 * vitamin_b7 <= 61)


# Immune support index constraints
model.addConstr(10 * magnesium + 8 * vitamin_b7 >= 10)
model.addConstr(7 * vitamin_b9 + 10 * magnesium >= 12)
model.addConstr(7 * vitamin_b9 + 10 * magnesium + 8 * vitamin_b7 >= 17)


# Cognitive performance index constraints
model.addConstr(4 * vitamin_b9 + 2 * magnesium >= 27)
model.addConstr(2 * magnesium + 5 * vitamin_b7 >= 21)
model.addConstr(4 * vitamin_b9 + 2 * magnesium + 5 * vitamin_b7 >= 21)

# Additional constraints
model.addConstr(5 * vitamin_b9 - 4 * vitamin_b7 >= 0)
model.addConstr(-10 * vitamin_b9 + 7 * magnesium >= 0)


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Vitamin B9: %g' % vitamin_b9.x)
    print('Magnesium: %g' % magnesium.x)
    print('Vitamin B7: %g' % vitamin_b7.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % model.status)
