
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
x0 = m.addVar(name="milligrams_of_vitamin_B9", lb=0)  # Non-negative
x1 = m.addVar(name="milligrams_of_magnesium", lb=0)  # Non-negative
x2 = m.addVar(name="milligrams_of_vitamin_B7", lb=0)  # Non-negative

# Objective function
m.setObjective(7 * x0 + 2 * x1 + 2 * x2, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(11 * x0 + 11 * x2 >= 23, name="muscle_growth_B9_B7")
m.addConstr(11 * x0 + 3 * x1 >= 8, name="muscle_growth_B9_Mg")
m.addConstr(11 * x0 + 3 * x1 + 11 * x2 >= 8, name="muscle_growth_all")
m.addConstr(10 * x1 + 8 * x2 >= 10, name="immune_support_Mg_B7")
m.addConstr(7 * x0 + 10 * x1 >= 12, name="immune_support_B9_Mg")
m.addConstr(7 * x0 + 10 * x1 + 8 * x2 >= 17, name="immune_support_all")
m.addConstr(4 * x0 + 2 * x1 >= 27, name="cognitive_performance_B9_Mg")
m.addConstr(2 * x1 + 5 * x2 >= 21, name="cognitive_performance_Mg_B7")
m.addConstr(4 * x0 + 2 * x1 + 5 * x2 >= 21, name="cognitive_performance_all")
m.addConstr(5 * x0 - 4 * x2 >= 0, name="B9_B7_relation")
m.addConstr(-10 * x0 + 7 * x1 >= 0, name="B9_Mg_relation")
m.addConstr(11 * x0 + 3 * x1 <= 70, name="muscle_growth_B9_Mg_limit")
m.addConstr(3 * x1 + 11 * x2 <= 61, name="muscle_growth_Mg_B7_limit")

# Solve the model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin B9: {x0.varValue}")
    print(f"Milligrams of magnesium: {x1.varValue}")
    print(f"Milligrams of vitamin B7: {x2.varValue}")
    print(f"Objective value: {m.objVal}")
else:
    print("No optimal solution found.")
