
from gurobipy import Model, GRB

# Create a new model
model = Model("vitamin_iron_optimization")

# Create variables
vitamin_b2 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b2")  # Continuous variable
iron = model.addVar(lb=0, vtype=GRB.INTEGER, name="iron")  # Integer variable

# Set objective function
model.setObjective(2 * vitamin_b2 + 2 * iron, GRB.MAXIMIZE)

# Add constraints
model.addConstr(24 * vitamin_b2 + 19 * iron >= 63, "kidney_support_min")
model.addConstr(20 * vitamin_b2 + 10 * iron >= 107, "cardiovascular_support_min")
model.addConstr(-8 * vitamin_b2 + 6 * iron >= 0, "constraint_3")
model.addConstr(24 * vitamin_b2 + 19 * iron <= 238, "kidney_support_max")
model.addConstr(20 * vitamin_b2 + 10 * iron <= 254, "cardiovascular_support_max")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Milligrams of Vitamin B2: {vitamin_b2.x}")
    print(f"Milligrams of Iron: {iron.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

