
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B2")
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="milligrams_of_iron")

# Objective function
m.setObjective(2*x0 + 2*x1, GRB.MAXIMIZE)

# Constraints
m.addConstr(24*x0 + 19*x1 >= 63, "kidney_support_index_lower_bound")
m.addConstr(20*x0 + 10*x1 >= 107, "cardiovascular_support_index_lower_bound")
m.addConstr(-8*x0 + 6*x1 >= 0, "linear_constraint")
m.addConstr(24*x0 + 19*x1 <= 238, "kidney_support_index_upper_bound")
m.addConstr(20*x0 + 10*x1 <= 254, "cardiovascular_support_index_upper_bound")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B2: {x0.x}")
    print(f"Milligrams of Iron: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
