
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams of vitamin B2")
    x1 = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER, name="milligrams of iron")

    # Objective function
    model.setObjective(2 * x0 + 2 * x1, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(24 * x0 + 19 * x1 >= 63, name="kidney_support_index")
    model.addConstr(20 * x0 + 10 * x1 >= 107, name="cardiovascular_support_index")
    model.addConstr(-8 * x0 + 6 * x1 >= 0, name="linear_constraint")
    model.addConstr(24 * x0 + 19 * x1 <= 238, name="kidney_support_index_upper_bound")
    model.addConstr(20 * x0 + 10 * x1 <= 254, name="cardiovascular_support_index_upper_bound")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B2: {x0.varValue}")
        print(f"Milligrams of iron: {x1.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("No feasible solution found.")
    else:
        print("Optimization failed.")

solve_optimization_problem()
